T1 = csvread('video_upperbound_source1_average.csv');
T2= csvread('video_upperbound_source2_average.csv');
T3= csvread('video_upperbound_source3_average.csv');
T4=csvread('video_upperbound_average.csv');


hold on

plot(T1(:,1),T1(:,2),'g','LineWidth',2);
legend('upp1')
hold on
plot(T2(:,1),T2(:,2),'cyan','LineWidth',2)
legend('upp2')
hold on
plot(T3(:,1),T3(:,2),'y','LineWidth',2)
legend('upp3')
hold on
plot(T4(:,1),T4(:,2),'color','#D95319','LineWidth',2)
legend('upp4')
box on;


legend('Source1-Target','Source2-Target','Source3-Target','Target','FontSize',14)
xlabel('Number of Target Samples','interpreter','latex','FontSize',20)
ylabel('Target Generalization Error','interpreter','latex','FontSize',20)
set(gca,'FontName','cmr12','Box','on')

print(gcf,'upperbounds-video.png','-dpng','-r300');



writematrix(t1,'video_upperbound_source1_average.csv')
writematrix(t2,'video_upperbound_source2_average.csv')
writematrix(t3,'video_upperbound_source3_average.csv')
writematrix(t4,'video_upperbound_average.csv')

